/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search2.internal.ui.text.WindowAnnotationManager;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AnnotationManagers {
    private static HashMap fgManagerMap = new HashMap();

    private static void disposeAnnotationManager(IWorkbenchWindow window) {
        WindowAnnotationManager mgr = (WindowAnnotationManager)fgManagerMap.remove(window);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    public static void searchResultActivated(IWorkbenchWindow window, AbstractTextSearchResult result) {
        WindowAnnotationManager mgr = (WindowAnnotationManager)fgManagerMap.get(window);
        if (mgr == null) {
            mgr = new WindowAnnotationManager(window);
            fgManagerMap.put(window, mgr);
        }
        mgr.setSearchResult(result);
    }

    static {
        IWindowListener listener = new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                AnnotationManagers.disposeAnnotationManager(window);
            }

            public void windowOpened(IWorkbenchWindow window) {
            }
        };
        PlatformUI.getWorkbench().addWindowListener(listener);
    }
}

