/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Vector;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class GoToAddressDialog
extends Dialog
implements ModifyListener {
    private static Vector history = new Vector();
    private Combo expressionInput;
    private String expression;
    private static final String PREFIX = "GoToAddressDialog.";
    private static final String GO_TO_ADDRESS = "GoToAddressDialog.GoToAddress";
    private static final String ADDRESS = "GoToAddressDialog.Address";

    public GoToAddressDialog(Shell parentShell) {
        super(parentShell);
        WorkbenchHelp.setHelp((Control)parentShell, (String)(IDebugUIConstants.PLUGIN_ID + ".GoToAddressDialog_context"));
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = true;
        spec2.grabExcessHorizontalSpace = true;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 2;
        parent.setLayoutData((Object)spec2);
        Label textLabel = new Label(parent, 0);
        textLabel.setText(DebugUIMessages.getString(ADDRESS));
        GridData textLayout = new GridData();
        textLayout.widthHint = 280;
        textLabel.setLayoutData((Object)textLayout);
        this.expressionInput = new Combo(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        spec.heightHint = 50;
        this.expressionInput.setLayoutData((Object)spec);
        String[] historyExpression = history.toArray(new String[history.size()]);
        for (int i = 0; i < historyExpression.length; ++i) {
            this.expressionInput.add(historyExpression[i]);
        }
        this.expressionInput.addModifyListener((ModifyListener)this);
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DebugUIMessages.getString(GO_TO_ADDRESS));
    }

    public String getExpression() {
        return this.expression;
    }

    protected void okPressed() {
        this.expression = this.expressionInput.getText();
        if (!history.contains(this.expression)) {
            history.insertElementAt(this.expression, 0);
        }
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        String input = this.expressionInput.getText();
        if (input == null || input.equals("")) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return ret;
    }
}

