/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class PerspectivesTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationListener {
    private ILaunchConfigurationType fType = null;
    private String[] fModeIds = null;
    private String[] fPerspectiveLabels = null;
    private Map fPerspectiveIds = null;
    private Combo[] fCombos = null;
    private Button fRestoreDefaults;
    private SelectionAdapter fSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PerspectivesTab.this.fRestoreDefaults) {
                this.handleRestoreDefaultsSelected();
            }
            PerspectivesTab.this.updateLaunchConfigurationDialog();
        }

        private void handleRestoreDefaultsSelected() {
            for (int i = 0; i < PerspectivesTab.this.fCombos.length; ++i) {
                String mode = (String)PerspectivesTab.this.fCombos[i].getData();
                String def = DebugUIPlugin.getDefault().getPerspectiveManager().getDefaultLaunchPerspective(PerspectivesTab.this.getLaunchConfigurationType(), mode);
                if (def == null) {
                    PerspectivesTab.this.fCombos[i].setText(LaunchConfigurationsMessages.getString("PerspectivesTab.1"));
                    continue;
                }
                IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor descriptor = registry.findPerspectiveWithId(def);
                PerspectivesTab.this.fCombos[i].setText(descriptor.getLabel());
            }
        }
    };
    private boolean fInitializing = false;

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy() && configuration.getName().startsWith(this.getLaunchConfigurationType().getIdentifier())) {
            for (int i = 0; i < this.fModeIds.length; ++i) {
                String mode = this.fModeIds[i];
                try {
                    String persp = configuration.getAttribute(mode, (String)null);
                    if (persp == null) {
                        persp = "perspective_default";
                    }
                    DebugUITools.setLaunchPerspective(this.getLaunchConfigurationType(), mode, persp);
                    continue;
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public PerspectivesTab(ILaunchConfigurationType type) {
        this.fType = type;
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public Image getImage() {
        return DebugPluginImages.getImage("IMG_OBJS_PERSPECTIVE_TAB");
    }

    public void createControl(Composite parent) {
        int i;
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_PERSPECTIVE_TAB);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 16448);
        label.setFont(parent.getFont());
        label.setText(MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectivesTab.0"), this.getLaunchConfigurationType().getName()));
        gd = new GridData();
        PixelConverter converter = new PixelConverter((Control)label);
        gd.widthHint = converter.convertWidthInCharsToPixels(80);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        ILaunchMode[] modes = DebugPlugin.getDefault().getLaunchManager().getLaunchModes();
        ArrayList<String> supported = new ArrayList<String>();
        for (int i2 = 0; i2 < modes.length; ++i2) {
            ILaunchMode mode = modes[i2];
            if (!this.getLaunchConfigurationType().supportsMode(mode.getIdentifier())) continue;
            supported.add(mode.getIdentifier());
        }
        this.fModeIds = supported.toArray(new String[supported.size()]);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        this.fPerspectiveLabels = new String[descriptors.length + 1];
        this.fPerspectiveLabels[0] = LaunchConfigurationsMessages.getString("PerspectivesTab.1");
        this.fPerspectiveIds = new HashMap(descriptors.length);
        for (i = 0; i < descriptors.length; ++i) {
            IPerspectiveDescriptor descriptor = descriptors[i];
            this.fPerspectiveLabels[i + 1] = descriptor.getLabel();
            this.fPerspectiveIds.put(descriptor.getLabel(), descriptor.getId());
        }
        this.createVerticalSpacer(composite, 2);
        this.fCombos = new Combo[this.fModeIds.length];
        for (i = 0; i < this.fModeIds.length; ++i) {
            label = new Label(composite, 0);
            label.setFont(composite.getFont());
            gd = new GridData(1);
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            String text = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.fModeIds[i]).getLabel();
            label.setText(MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectivesTab.2"), text));
            Combo combo = new Combo(composite, 8);
            combo.setFont(composite.getFont());
            combo.setItems(this.fPerspectiveLabels);
            combo.setData((Object)this.fModeIds[i]);
            gd = new GridData(1);
            combo.setLayoutData((Object)gd);
            this.fCombos[i] = combo;
            combo.addSelectionListener((SelectionListener)this.fSelectionAdapter);
        }
        this.createVerticalSpacer(composite, 2);
        this.fRestoreDefaults = this.createPushButton(composite, LaunchConfigurationsMessages.getString("PerspectivesTab.3"), null);
        this.fRestoreDefaults.addSelectionListener((SelectionListener)this.fSelectionAdapter);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (int i = 0; i < this.fModeIds.length; ++i) {
            String mode = this.fModeIds[i];
            configuration.setAttribute(mode, (String)null);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        for (int i = 0; i < this.fModeIds.length; ++i) {
            String mode = this.fModeIds[i];
            try {
                String persp = configuration.getAttribute(mode, (String)null);
                if (persp == null) {
                    persp = DebugUITools.getLaunchPerspective(this.getLaunchConfigurationType(), mode);
                }
                if ("perspective_none".equals(persp)) {
                    persp = null;
                }
                IPerspectiveDescriptor descriptor = null;
                if (persp != null) {
                    descriptor = registry.findPerspectiveWithId(persp);
                }
                if (descriptor == null) {
                    this.fCombos[i].setText(LaunchConfigurationsMessages.getString("PerspectivesTab.1"));
                    continue;
                }
                this.fCombos[i].setText(descriptor.getLabel());
                continue;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        this.fInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (int i = 0; i < this.fCombos.length; ++i) {
            this.updateConfigFromCombo(this.fCombos[i], configuration);
        }
    }

    protected void updateConfigFromCombo(Combo combo, ILaunchConfigurationWorkingCopy workingCopy) {
        if (!this.fInitializing) {
            String mode = (String)combo.getData();
            String persp = combo.getText();
            persp = persp.equals(LaunchConfigurationsMessages.getString("PerspectivesTab.1")) ? "perspective_none" : (String)this.fPerspectiveIds.get(persp);
            String def = DebugUIPlugin.getDefault().getPerspectiveManager().getDefaultLaunchPerspective(this.getLaunchConfigurationType(), mode);
            if (def == null) {
                def = "perspective_none";
            }
            if (persp.equals(def)) {
                persp = null;
            }
            workingCopy.setAttribute(mode, persp);
        }
    }

    public String getName() {
        return LaunchConfigurationsMessages.getString("PerspectivesTab.7");
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return this.fType;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public String getMessage() {
        String description = super.getMessage();
        if (this.fType != null) {
            String mode = this.getLaunchConfigurationDialog().getMode();
            LaunchConfigurationPresentationManager manager = LaunchConfigurationPresentationManager.getDefault();
            LaunchConfigurationTabGroupExtension extension = manager.getExtension(this.fType.getAttribute("id"), mode);
            description = extension.getDescription(mode);
        }
        return description;
    }
}

