/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.JavaFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class JavaTextFileBuffer
extends JavaFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("FileBuffer.status.ok"), null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, FileBuffersMessages.getString("FileBuffer.status.error"), null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    private String fExplicitEncoding;
    private boolean fHasBOM;

    public JavaTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IAnnotationModel getAnnotationModel() {
        return null;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public IStatus getStatus() {
        if (!this.isDisposed()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    private InputStream getFileContents(IProgressMonitor monitor) {
        try {
            return new FileInputStream(this.fFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileContents(InputStream stream, boolean overwrite, IProgressMonitor monitor) {
        try {
            FileOutputStream out = new FileOutputStream(this.fFile, false);
            try {
                byte[] buffer = new byte[8192];
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = stream.read(buffer);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (bytesRead == -1) break;
                    try {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    monitor.worked(1);
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    stream.close();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void revert(IProgressMonitor monitor) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        IDocument original = null;
        IStatus status = null;
        try {
            original = this.fManager.createEmptyDocument(this.getLocation());
            this.setDocumentContent(original, this.getFileContents(monitor), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        this.fStatus = status;
        if (original != null) {
            boolean replaceContents;
            String originalContents = original.get();
            boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            block11: {
                InputStream stream;
                block10: {
                    this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
                    this.fEncoding = null;
                    this.fHasBOM = false;
                    stream = this.getFileContents(monitor);
                    QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFile.getName(), options);
                    if (description == null) break block10;
                    this.fEncoding = description.getCharset();
                    this.fHasBOM = description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                }
                Object var6_7 = null;
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("JavaTextFileBuffer.error.closeStream"), (Throwable)ex));
                }
                break block11;
                {
                    catch (IOException iOException) {
                        Object var6_8 = null;
                        try {
                            stream.close();
                        }
                        catch (IOException ex) {
                            FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("JavaTextFileBuffer.error.closeStream"), (Throwable)ex));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("JavaTextFileBuffer.error.closeStream"), (Throwable)ex));
                    }
                    throw throwable;
                }
            }
            this.setDocumentContent(this.fDocument, this.getFileContents(monitor), this.fEncoding);
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        String encoding = this.computeEncoding();
        try {
            byte[] bytes = this.fDocument.get().getBytes(encoding);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                int bomLength = IContentDescription.BOM_UTF_8.length;
                byte[] bytesWithBOM = new byte[bytes.length + bomLength];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, bytesWithBOM, 0, bomLength);
                System.arraycopy(bytes, 0, bytesWithBOM, bomLength, bytes.length);
                bytes = bytesWithBOM;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            if (this.fFile.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                this.setFileContents(stream, overwrite, monitor);
                this.fSynchronizationStamp = this.fFile.lastModified();
            }
        }
        catch (UnsupportedEncodingException x) {
            String message = FileBuffersMessages.getFormattedString("ResourceTextFileBuffer.error.unsupported_encoding.message_arg", encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private String computeEncoding() {
        block12: {
            BufferedReader reader;
            block11: {
                String encoding;
                if (this.fExplicitEncoding != null) {
                    return this.fExplicitEncoding;
                }
                reader = new BufferedReader(new StringReader(this.fDocument.get()));
                QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFile.getName(), options);
                if (description == null || (encoding = description.getCharset()) == null) break block11;
                String string = encoding;
                Object var7_7 = null;
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                }
                return string;
            }
            Object var7_8 = null;
            try {
                ((Reader)reader).close();
            }
            catch (IOException ex) {
                FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
            }
            break block12;
            {
                catch (IOException iOException) {
                    Object var7_9 = null;
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException ex) {
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                }
                throw throwable;
            }
        }
        if (this.fHasBOM) {
            return this.fEncoding;
        }
        return this.fManager.getDefaultEncoding();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        Reader in = null;
        try {
            try {
                if (encoding == null) {
                    encoding = this.fManager.getDefaultEncoding();
                }
                if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                    contentStream.read(new byte[IContentDescription.BOM_UTF_8.length]);
                }
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 16384);
                StringBuffer buffer = new StringBuffer(16384);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(buffer.toString());
            }
            catch (IOException x) {
                String msg = x.getMessage() == null ? "" : x.getMessage();
                Status s = new Status(4, "org.eclipse.core.filebuffers", 0, msg, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
            Object var9_11 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException x) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException x) {}
        in.close();
        return;
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.isSynchronized()) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, FileBuffersMessages.getString("FileBuffer.error.outOfSync"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            JavaTextFileBuffer.this.fCanBeSaved = true;
            JavaTextFileBuffer.this.removeFileBufferContentListeners();
            JavaTextFileBuffer.this.fManager.fireDirtyStateChanged(JavaTextFileBuffer.this, JavaTextFileBuffer.this.fCanBeSaved);
        }
    }
}

