/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;

public class SocketUtil {
    private static final Random random = new Random(System.currentTimeMillis());

    public static int findUnusedLocalPort(InetAddress address) {
        try {
            if (address == null) {
                address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
        }
        catch (UnknownHostException uhe) {
            return -1;
        }
        int port = SocketUtil.findUnusedPort(address, 49152, 65535);
        if (port == -1) {
            port = SocketUtil.findFreePort();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int findUnusedPort(InetAddress address, int from, int to) {
        for (int i = 0; i < 12; ++i) {
            IOException ioe22;
            Object var9_8;
            int n;
            ServerSocket ss;
            block10: {
                ss = null;
                int port = SocketUtil.getRandomPort(from, to);
                ss = new ServerSocket();
                InetSocketAddress sa = new InetSocketAddress(address, port);
                ss.bind(sa);
                n = ss.getLocalPort();
                var9_8 = null;
                if (ss == null) break block10;
                try {
                    ss.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            return n;
            catch (IOException e) {
                try {
                    var9_8 = null;
                    if (ss == null) continue;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (IOException ioe22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ss.close();
                }
                catch (IOException ioe22) {}
                continue;
            }
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return (int)(random.nextFloat() * (float)(high - low)) + low;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        socket = new ServerSocket(0);
        int n = socket.getLocalPort();
        Object var3_3 = null;
        if (socket == null) return n;
        try {
            socket.close();
            return n;
        }
        catch (IOException e) {
            // empty catch block
        }
        return n;
        catch (IOException iOException) {
            try {
                Object var3_4 = null;
                if (socket == null) return -1;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                socket.close();
                return -1;
            }
            catch (IOException e) {}
            return -1;
        }
    }
}

