/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class CheckedListDialogField
extends ListDialogField {
    private int fCheckAllButtonIndex = -1;
    private int fUncheckAllButtonIndex = -1;
    private List fCheckElements = new ArrayList();

    public CheckedListDialogField(IListAdapter adapter, String[] customButtonLabels, ILabelProvider lprovider) {
        super(adapter, customButtonLabels, lprovider);
    }

    public void setCheckAllButtonIndex(int checkButtonIndex) {
        Assert.isTrue((checkButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = checkButtonIndex;
    }

    public void setUncheckAllButtonIndex(int uncheckButtonIndex) {
        Assert.isTrue((uncheckButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = uncheckButtonIndex;
    }

    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 32 + this.getListStyle());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                CheckedListDialogField.this.doCheckStateChanged(e);
            }
        });
        return tableViewer;
    }

    public Control getListControl(Composite parent) {
        Control control = super.getListControl(parent);
        if (parent != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckElements.toArray());
        }
        return control;
    }

    public void dialogFieldChanged() {
        for (int i = this.fCheckElements.size() - 1; i >= 0; --i) {
            if (this.fElements.contains(this.fCheckElements.get(i))) continue;
            this.fCheckElements.remove(i);
        }
        super.dialogFieldChanged();
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    public List getCheckedElements() {
        if (this.isOkToUse(this.fTableControl)) {
            Object[] checked = ((CheckboxTableViewer)this.fTable).getCheckedElements();
            ArrayList<Object> res = new ArrayList<Object>(checked.length);
            for (int i = 0; i < checked.length; ++i) {
                res.add(checked[i]);
            }
            return res;
        }
        return new ArrayList(this.fCheckElements);
    }

    public int getCheckedSize() {
        return this.fCheckElements.size();
    }

    public boolean isChecked(Object obj) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getChecked(obj);
        }
        return this.fCheckElements.contains(obj);
    }

    public void setCheckedElements(Collection list) {
        this.fCheckElements = new ArrayList(list);
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(list.toArray());
        }
        this.checkStateChanged();
    }

    public void setChecked(Object object, boolean state) {
        this.setCheckedWithoutUpdate(object, state);
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(Object object, boolean state) {
        if (state) {
            if (!this.fCheckElements.contains(object)) {
                this.fCheckElements.add(object);
            }
        } else {
            this.fCheckElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, state);
        }
    }

    public void checkAll(boolean state) {
        if (state) {
            this.fCheckElements = this.getElements();
        } else {
            this.fCheckElements.clear();
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(state);
        }
        this.checkStateChanged();
    }

    private void doCheckStateChanged(CheckStateChangedEvent e) {
        if (e.getChecked()) {
            this.fCheckElements.add(e.getElement());
        } else {
            this.fCheckElements.remove(e.getElement());
        }
        this.checkStateChanged();
    }

    public void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        boolean wasChecked = this.isChecked(oldElement);
        super.replaceElement(oldElement, newElement);
        this.setChecked(newElement, wasChecked);
    }

    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (index == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(sel, index);
    }

    protected boolean managedButtonPressed(int index) {
        if (index == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (index == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(index);
        }
        return true;
    }
}

