/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultLabelProvider;
import org.eclipse.swt.graphics.Image;

class OccurrencesInFileLabelProvider
extends JavaSearchResultLabelProvider {
    OccurrencesInFileLabelProvider() {
    }

    public String getText(Object o) {
        IMarker marker = this.getMarker(o);
        try {
            String text = (String)marker.getAttribute("message");
            if (text != null) {
                return text.replace('\t', ' ');
            }
        }
        catch (CoreException ex) {
            return "";
        }
        return super.getText(o);
    }

    public Image getImage(Object element) {
        IMarker marker = this.getMarker(element);
        if (this.isVariableAccess(marker)) {
            if (this.isWriteAccess(marker)) {
                return JavaPluginImages.get("org.eclipse.jdt.ui.occ_write.gif");
            }
            return JavaPluginImages.get("org.eclipse.jdt.ui.occ_read.gif");
        }
        return JavaPluginImages.get("org.eclipse.jdt.ui.occ_match.gif");
    }

    private boolean isWriteAccess(IMarker marker) {
        Boolean write = null;
        boolean writeValue = false;
        try {
            write = (Boolean)marker.getAttribute("writeAccess");
            writeValue = write != null && write != false;
        }
        catch (CoreException e) {
            // empty catch block
        }
        return writeValue;
    }

    private boolean isVariableAccess(IMarker marker) {
        Boolean variable = null;
        boolean variableValue = false;
        try {
            variable = (Boolean)marker.getAttribute("variable");
            variableValue = variable != null && variable != false;
        }
        catch (CoreException e) {
            // empty catch block
        }
        return variableValue;
    }
}

