/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FullFeatureParser
extends DefaultHandler
implements IConfigurationConstants {
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;
    private boolean isDescription;
    private StringBuffer description = new StringBuffer();
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FullFeatureParser(FeatureEntry feature) {
        this.feature = feature;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() {
        in = null;
        try {
            block12: {
                if (this.feature.getSite() != null) break block12;
                var4_2 = null;
                if (in == null) return;
                ** GOTO lbl44
            }
            this.url = new URL(this.feature.getSite().getResolvedURL(), this.feature.getURL() + "feature.xml");
            in = this.url.openStream();
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
            ** GOTO lbl50
        }
        catch (SAXException e) {
            var4_4 = null;
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
                return;
            }
        }
        catch (IOException var2_13) {
            var4_5 = null;
            if (in == null) return;
            try {}
            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
                return;
            }
            in.close();
            return;
        }
        {
            catch (Throwable var3_14) {
                var4_6 = null;
                if (in == null) throw var3_14;
                ** try [egrp 2[TRYBLOCK] [9 : 118->125)] { 
lbl39:
                // 1 sources

                in.close();
                throw var3_14;
lbl41:
                // 1 sources

                catch (IOException e1) {
                    Utils.log(e1.getLocalizedMessage());
                }
                throw var3_14;
            }
lbl44:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 118->125)] { 
lbl45:
            // 1 sources

            in.close();
            return;
lbl47:
            // 1 sources

            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
            }
            return;
lbl50:
            // 1 sources

            var4_3 = null;
            if (in == null) return;
            try {}
            catch (IOException e1) {}
            Utils.log(e1.getLocalizedMessage());
            return;
            in.close();
            return;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("description".equals(localName)) {
            this.isDescription = true;
        } else if ("license".equals(localName)) {
            this.processLicense(attributes);
        }
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            System.out.println(Messages.getString("FeatureParser.IdOrVersionInvalid", new String[]{id, ver}));
        } else {
            String arch;
            String ws;
            String nl = attributes.getValue("nl");
            String os = attributes.getValue("os");
            if (!Utils.isValidEnvironment(os, ws = attributes.getValue("ws"), arch = attributes.getValue("arch"), nl)) {
                return;
            }
            PluginEntry plugin = new PluginEntry();
            plugin.setPluginIdentifier(id);
            plugin.setPluginVersion(ver);
            this.feature.addPlugin(plugin);
            Utils.debug("End process DefaultFeature tag: id:" + id + " ver:" + ver + " url:" + this.feature.getURL());
        }
    }

    private void processLicense(Attributes attributes) {
        this.feature.setLicenseURL(attributes.getValue("url"));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isDescription) {
            return;
        }
        this.description.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("description".equals(localName)) {
            this.isDescription = false;
            String d = this.description.toString().trim();
            ResourceBundle bundle = this.feature.getResourceBundle();
            this.feature.setDescription(Utils.getResourceString(bundle, d));
        }
    }
}

